<?php
require 'config.php';

// Check if user is logged in
$user_id = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : null;
$is_admin = isset($_SESSION['is_admin']) ? $_SESSION['is_admin'] : false;
?>

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SourceHub - Digital Projects Marketplace</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            color: #333;
        }
        
        header {
            background: white;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        nav {
            max-width: 1200px;
            margin: 0 auto;
            padding: 15px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .logo {
            font-size: 28px;
            font-weight: bold;
            color: #667eea;
            text-decoration: none;
        }
        
        .nav-links {
            display: flex;
            gap: 20px;
            align-items: center;
            flex-wrap: wrap;
        }
        
        .nav-links a, .nav-links button {
            text-decoration: none;
            color: #333;
            padding: 8px 15px;
            border-radius: 5px;
            border: none;
            cursor: pointer;
            transition: all 0.3s;
            background: none;
            font-size: 14px;
        }
        
        .nav-links a:hover {
            background: #f0f0f0;
        }
        
        .btn-login {
            background: #667eea;
            color: white !important;
        }
        
        .btn-login:hover {
            background: #764ba2;
        }
        
        .btn-logout {
            background: #e74c3c;
            color: white !important;
        }
        
        .btn-logout:hover {
            background: #c0392b;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        .hero {
            background: white;
            border-radius: 15px;
            padding: 60px 20px;
            text-align: center;
            margin-bottom: 40px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
        }
        
        .hero h1 {
            font-size: 48px;
            margin-bottom: 15px;
            color: #2c3e50;
        }
        
        .hero p {
            font-size: 18px;
            color: #7f8c8d;
            margin-bottom: 30px;
        }
        
        .hero-buttons {
            display: flex;
            gap: 15px;
            justify-content: center;
            flex-wrap: wrap;
        }
        
        .btn {
            padding: 12px 30px;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s;
            text-decoration: none;
            display: inline-block;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
        }
        
        .projects-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(280px, 1fr));
            gap: 20px;
            margin-bottom: 40px;
        }
        
        .project-card {
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            transition: all 0.3s;
        }
        
        .project-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0,0,0,0.2);
        }
        
        .project-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            min-height: 100px;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
        }
        
        .project-header h3 {
            font-size: 18px;
        }
        
        .project-body {
            padding: 20px;
        }
        
        .project-body p {
            color: #7f8c8d;
            font-size: 14px;
            margin-bottom: 15px;
            line-height: 1.5;
        }
        
        .price {
            font-size: 24px;
            font-weight: bold;
            color: #667eea;
            margin-bottom: 15px;
        }
        
        .tech-tags {
            display: flex;
            flex-wrap: wrap;
            gap: 5px;
            margin-bottom: 15px;
        }
        
        .tech-tag {
            background: #ecf0f1;
            padding: 3px 8px;
            border-radius: 3px;
            font-size: 12px;
            color: #667eea;
        }
        
        .project-footer {
            padding: 15px 20px;
            border-top: 1px solid #ecf0f1;
        }
        
        .btn-small {
            padding: 8px 15px;
            font-size: 14px;
            width: 100%;
            text-align: center;
        }
        
        .form-container {
            background: white;
            border-radius: 10px;
            padding: 40px;
            max-width: 400px;
            margin: 40px auto;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            color: #2c3e50;
            font-weight: bold;
        }
        
        .form-group input {
            width: 100%;
            padding: 10px;
            border: 1px solid #bdc3c7;
            border-radius: 5px;
            font-size: 14px;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 5px rgba(102, 126, 234, 0.3);
        }
        
        .alert {
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        
        .alert-error {
            background: #fadbd8;
            color: #c0392b;
            border-left: 4px solid #c0392b;
        }
        
        .alert-success {
            background: #d5f4e6;
            color: #27ae60;
            border-left: 4px solid #27ae60;
        }
        
        .dashboard-table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        
        .dashboard-table th {
            background: #2c3e50;
            color: white;
            padding: 15px;
            text-align: left;
        }
        
        .dashboard-table td {
            padding: 15px;
            border-bottom: 1px solid #ecf0f1;
        }
        
        .dashboard-table tr:hover {
            background: #f8f9fa;
        }
        
        .admin-panel {
            background: white;
            border-radius: 10px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            padding: 20px;
            border-radius: 10px;
            text-align: center;
            color: white;
        }
        
        .stat-card h3 {
            font-size: 32px;
            margin-bottom: 10px;
        }
        
        .stat-card p {
            font-size: 14px;
            opacity: 0.9;
        }
        
        .project-detail {
            background: white;
            border-radius: 10px;
            padding: 30px;
            max-width: 800px;
            margin: 0 auto;
            box-shadow: 0 10px 30px rgba(0,0,0,0.2);
        }
        
        .project-detail h1 {
            margin-bottom: 20px;
            color: #2c3e50;
        }
        
        .project-detail-description {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 5px;
            margin: 20px 0;
            line-height: 1.6;
        }
        
        .project-detail-footer {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin: 30px 0;
            padding: 20px 0;
            border-top: 1px solid #ecf0f1;
            border-bottom: 1px solid #ecf0f1;
        }
        
        .project-detail-footer h2 {
            color: #667eea;
        }
        
        footer {
            background: #2c3e50;
            color: white;
            text-align: center;
            padding: 20px;
            margin-top: 40px;
        }
        
        .user-welcome {
            color: white;
            font-weight: bold;
            background: #667eea;
            padding: 8px 15px;
            border-radius: 5px;
        }
        
        @media (max-width: 768px) {
            .hero h1 {
                font-size: 32px;
            }
            
            .nav-links {
                gap: 10px;
            }
            
            .projects-grid {
                grid-template-columns: 1fr;
            }
            
            .project-detail-footer {
                flex-direction: column;
                gap: 20px;
            }
        }
    </style>
</head>
<body>
    <header>
        <nav>
            <a href="index.php" class="logo">🚀 SourceHub</a>
            <div class="nav-links">
                <a href="index.php">Home</a>
                <a href="projects.php">Projects</a>
                <?php if ($user_id): ?>
                    <a href="dashboard.php">Dashboard</a>
                    <?php if ($is_admin): ?>
                        <a href="admin.php" style="color: #f39c12; font-weight: bold;">🔒 Admin</a>
                    <?php endif; ?>
                    <span class="user-welcome">👤 <?php echo htmlspecialchars($_SESSION['user_name']); ?></span>
                    <button class="btn-logout" onclick="window.location.href='logout.php'">Logout</button>
                <?php else: ?>
                    <a href="login.php">Login</a>
                    <a href="register.php">Register</a>
                <?php endif; ?>
            </div>
        </nav>
    </header>

    <div class="container">
        <!-- HOME PAGE -->
        <div class="hero">
            <h1>Welcome to SourceHub</h1>
            <p>Buy and sell digital projects, source code, and web applications</p>
            <div class="hero-buttons">
                <a href="projects.php" class="btn btn-primary">Browse Projects</a>
                <?php if (!$user_id): ?>
                    <a href="login.php" class="btn btn-primary">Get Started</a>
                <?php endif; ?>
            </div>
        </div>

        <h2 style="color: white; margin-bottom: 30px; text-align: center;">Featured Projects</h2>
        <div class="projects-grid">
            <?php
            $projects = $conn->query("SELECT * FROM projects LIMIT 6");
            while ($project = $projects->fetch_assoc()):
            ?>
            <div class="project-card">
                <div class="project-header">
                    <h3><?php echo htmlspecialchars($project['title']); ?></h3>
                </div>
                <div class="project-body">
                    <p><?php echo htmlspecialchars($project['short_description']); ?></p>
                    <div class="price">$<?php echo number_format($project['price'], 2); ?></div>
                    <div class="tech-tags">
                        <?php 
                        $techs = array_slice(explode(',', $project['tech_stack']), 0, 3);
                        foreach ($techs as $tech):
                        ?>
                        <span class="tech-tag"><?php echo htmlspecialchars(trim($tech)); ?></span>
                        <?php endforeach; ?>
                    </div>
                </div>
                <div class="project-footer">
                    <a href="project.php?id=<?php echo $project['id']; ?>" class="btn btn-primary btn-small">View Details</a>
                </div>
            </div>
            <?php endwhile; ?>
        </div>
    </div>

    <footer>
        <p>&copy; 2024 SourceHub - Digital Projects Marketplace. All rights reserved.</p>
        <p style="font-size: 12px; margin-top: 10px;">Built with Pure PHP + MySQLi | Ready for cPanel</p>
    </footer>
</body>
</html>
